/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.ComputerSystemProvUtils;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.indication.server.HSCEventQueue;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscConstants;
import com.ibm.hsc.common.util.HscLockManager;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.ProviderLceCommunication;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import com.ibm.hsc.frame.BPAClientExt;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class FrameUtils {
    static final int IOCLUSTER_SIZE = 2;
    static final int HWSERVER_ERR = 2548;
    private static final int SET_PORT_NUM = 1;
    private static final int SET_FRAME_NUMBER = 2;
    private static final int SET_ON_BPA_FRAME_TYPE = 4;
    private static final int SET_OFF_BPA_FRAME_TYPE = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CIMValue initFrame(CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("##### The frame name is :" + string);
        System.out.println("##### Obtaining the frame lock #####");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("initFrame"));
            CIMValue cIMValue = FrameUtils.initFrame0(cIMObjectPath, string, providerCIMOMHandle);
            Object var7_6 = null;
            System.out.println("##### Releasing the frame lock #####");
            hscCecLock.Unlock();
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            System.out.println("##### Releasing the frame lock #####");
            hscCecLock.Unlock();
            throw throwable;
        }
    }

    protected static CIMValue initFrame0(CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Object var4_3 = null;
        String string2 = "";
        boolean bl = false;
        Trace.trace("apihhscT", "->in FrameUtils.initFrame method");
        System.out.println("In initFrame!");
        try {
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
            System.out.println("Frame instance: " + cIMInstance);
            System.out.println("port nums value: " + cIMInstance.getProperty("PortNum").getValue());
            if (cIMInstance.getProperty("PortNum").getValue() == null) {
                throw new HSCCIMException("305F");
            }
            Vector vector = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
            UnsignedInt32[] unsignedInt32Array = vector.toArray(new UnsignedInt32[0]);
            System.out.println("frameName: " + string);
            long l = 0L;
            int n = unsignedInt32Array.length;
            int n2 = -1;
            int n3 = 0;
            BPAClientExt bPAClientExt = BPAClientExt.getInstance();
            try {
                int n4 = 0;
                while (n4 < n) {
                    n3 = n4;
                    l = unsignedInt32Array[n4].longValue();
                    n2 = bPAClientExt.powerOnAllIo(l);
                    System.out.println("powerOnAllIo Status: " + n2 + " port: " + l);
                    if (n2 == 0) break;
                    FrameUtils.checkHWServer(n2);
                    ++n4;
                }
                System.out.println("status at end: " + n2);
                System.out.println("using port number: " + l);
                System.out.println("bpa index: " + n3);
                if (n2 != 0) {
                    System.out.println("Problem powering on IO");
                    string2 = "3051";
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                string2 = "3051";
            }
            int[] nArray = new int[17];
            String[] stringArray = new String[17];
            int[] nArray2 = new int[17];
            int[] nArray3 = new int[17];
            n2 = -1;
            int n5 = n3;
            while (n5 < n) {
                n3 = n5;
                l = unsignedInt32Array[n5].longValue();
                n2 = bPAClientExt.getFrameInfo(l, nArray, stringArray, nArray2, nArray3);
                System.out.println("getFrameInfo Status: " + n2 + " port: " + l);
                if (n2 == 0) break;
                System.out.println("Return code: " + n2);
                FrameUtils.checkHWServer(n2);
                ++n5;
            }
            System.out.println("status at end: " + n2);
            System.out.println("port num: " + l);
            System.out.println("bpa index: " + n3);
            if (n2 != 0) {
                System.out.println("error in getFrameInfo call - return code: " + n2);
                string2 = "3052";
            }
            int n6 = 0;
            while (n6 < nArray.length) {
                System.out.println("objType[" + n6 + "] = " + nArray[n6]);
                ++n6;
            }
            Vector<String> vector2 = new Vector<String>();
            String string3 = null;
            int n7 = 0;
            while (n7 < stringArray.length) {
                int n8 = nArray[n7];
                string3 = stringArray[n7];
                if (n8 == 16 || n8 == 17) {
                    vector2.addElement(string3);
                }
                ++n7;
            }
            CIMInstance cIMInstance2 = null;
            int n9 = 0;
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[vector2.size()];
            System.out.println("Number of CEC's to power on: " + vector2.size());
            int n10 = 0;
            while (n10 < vector2.size()) {
                boolean bl2 = true;
                string3 = (String)vector2.elementAt(n10);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)string3));
                cIMObjectPathArray[n10] = cIMObjectPath2;
                try {
                    cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
                    System.out.println("cecInst: " + cIMInstance2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    bl2 = false;
                }
                if (bl2 && cIMInstance2 != null) {
                    n9 = ((UnsignedInt8)cIMInstance2.getProperty("State").getValue().getValue()).intValue();
                    System.out.println("The csp's state is: " + n9);
                    if (n9 == 3 || n9 == 12) {
                        Vector<Object> vector3 = new Vector<Object>();
                        vector3.setSize(2);
                        if (GlobalConfig.callMethodsWithValues) {
                            vector3.setElementAt(new CIMValue((Object)HscConstants.POWER_ON_STANDBY), 0);
                        } else {
                            vector3.setElementAt(new CIMProperty("BootMode", new CIMValue((Object)HscConstants.POWER_ON_STANDBY)), 0);
                        }
                        System.out.println("set 1st element!");
                        if (GlobalConfig.callMethodsWithValues) {
                            vector3.setElementAt(new CIMValue((Object)new UnsignedInt8(255)), 1);
                        } else {
                            vector3.setElementAt(new CIMProperty("PowerOnMode", new CIMValue((Object)new UnsignedInt8(255))), 1);
                        }
                        System.out.println("set 2nd element!");
                        Vector vector4 = new Vector();
                        try {
                            providerCIMOMHandle.invokeMethod(cIMObjectPath2, "PowerOn", vector3, vector4);
                        }
                        catch (Throwable throwable) {
                            System.out.println("Error in powering on CEC!");
                            throwable.printStackTrace();
                            bl = true;
                        }
                    }
                }
                ++n10;
            }
            if (string2 != "" || bl) {
                if (bl) {
                    throw new HSCCIMException("3052");
                }
                throw new HSCCIMException(string2);
            }
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<-in FrameUtils.initFrame method");
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<-in FrameUtils.initFrame method");
            throw new HSCCIMException("3053 " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CIMValue getFrameInfo(CIMObjectPath cIMObjectPath, Vector vector, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("FrameUtils.getFrameInfo....");
        System.out.println("*****The frame name is :" + string);
        System.out.println("*****Obtaining the  frame lock *****");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("getFrameInfo"));
            CIMValue cIMValue = FrameUtils.getFrameInfo0(cIMObjectPath, vector, providerCIMOMHandle);
            Object var8_7 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            throw throwable;
        }
    }

    protected static CIMValue getFrameInfo0(CIMObjectPath cIMObjectPath, Vector vector, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apihhscT", "-> in FrameUtils.getFrameInfo method");
        System.out.println("In getFrameInfo!");
        try {
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
            System.out.println("Frame instance: " + cIMInstance);
            System.out.println("getting port numbers!");
            System.out.println("value: " + cIMInstance.getProperty("PortNum").getValue());
            if (cIMInstance.getProperty("PortNum").getValue() == null) {
                throw new HSCCIMException("305F");
            }
            Vector vector2 = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
            UnsignedInt32[] unsignedInt32Array = vector2.toArray(new UnsignedInt32[0]);
            int n = unsignedInt32Array.length;
            int n2 = -1;
            int n3 = 0;
            long l = 0L;
            short s = ((UnsignedInt16)cIMInstance.getProperty("frameType").getValue().getValue()).shortValue();
            System.out.println("FrameUtils.getFrameInfo0() - frameType = " + Integer.toHexString(s));
            BPAClientExt bPAClientExt = BPAClientExt.getInstance();
            int[] nArray = new int[17];
            String[] stringArray = new String[17];
            int[] nArray2 = new int[17];
            int[] nArray3 = new int[17];
            int n4 = s == 1 ? 1 : 0;
            int n5 = 0;
            while (n5 < n) {
                n3 = n5;
                l = unsignedInt32Array[n5].longValue();
                n2 = bPAClientExt.getFrameInfo(l, nArray, stringArray, nArray2, nArray3);
                System.out.println("getFrameInfo Status: " + n2 + " port: " + l);
                if (n2 == 0) break;
                System.out.println("Return code: " + n2);
                FrameUtils.checkHWServer(n2);
                ++n5;
            }
            System.out.println("status at end: " + n2);
            System.out.println("used port number: " + l);
            System.out.println("bpa index: " + n3);
            if (n2 != 0) {
                System.out.println("getFrameInfo return code: " + n2);
                throw new HSCCIMException("3058");
            }
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<UnsignedInt8> vector5 = new Vector<UnsignedInt8>();
            Vector<String> vector6 = new Vector<String>();
            Vector<UnsignedInt8> vector7 = new Vector<UnsignedInt8>();
            Vector<String> vector8 = new Vector<String>();
            Vector<UnsignedInt8> vector9 = new Vector<UnsignedInt8>();
            String string = "";
            int n6 = 0;
            while (n6 < nArray3.length) {
                int n7 = nArray[n6];
                int n8 = nArray3[n6];
                string = stringArray[n6];
                System.out.println("FrameUtils.getFrameInfo0() - objType[" + n6 + "] = " + n7);
                if ((n7 & 0xF0) == 32) {
                    System.out.println("I/O mtms: " + string);
                    vector3.addElement(string);
                    if ((nArray2[n6] & 0x80) == 128) {
                        vector4.addElement("");
                        System.out.println("orphan IO!");
                    } else {
                        String string2 = stringArray[n8];
                        vector4.addElement(string2);
                        System.out.println("corresponding CEC MTMS: " + string2);
                    }
                    System.out.println("IO Cage number: " + n6);
                    vector5.addElement(new UnsignedInt8((short)(n6 - n4)));
                } else if (n7 == 16 || n7 == 17) {
                    vector6.addElement(string);
                    System.out.println("CEC Mtms: " + vector6);
                    vector7.addElement(new UnsignedInt8((short)(n6 - n4)));
                    System.out.println("CEC cage number: " + n6);
                } else if (n7 == 48) {
                    vector8.addElement(string);
                    System.out.println("FSN Mtms: " + vector8);
                    vector9.addElement(new UnsignedInt8((short)(n6 - n4)));
                    System.out.println("FSN cage number: " + n6);
                }
                ++n6;
            }
            vector.setSize(7);
            if (GlobalConfig.callMethodsWithValues) {
                vector.setElementAt(new CIMValue(vector3, new CIMDataType(29)), 0);
                vector.setElementAt(new CIMValue(vector4, new CIMDataType(29)), 1);
                vector.setElementAt(new CIMValue(vector5, new CIMDataType(21)), 2);
                vector.setElementAt(new CIMValue(vector6, new CIMDataType(29)), 3);
                vector.setElementAt(new CIMValue(vector7, new CIMDataType(21)), 4);
                vector.setElementAt(new CIMValue(vector8, new CIMDataType(29)), 5);
                vector.setElementAt(new CIMValue(vector9, new CIMDataType(21)), 6);
            } else {
                vector.setElementAt(new CIMProperty("IODrawerMtms", new CIMValue(vector3, new CIMDataType(29))), 0);
                vector.setElementAt(new CIMProperty("IOMatchingCECMtms", new CIMValue(vector4, new CIMDataType(29))), 1);
                vector.setElementAt(new CIMProperty("IOCageNum", new CIMValue(vector5, new CIMDataType(21))), 2);
                vector.setElementAt(new CIMProperty("CECMtms", new CIMValue(vector6, new CIMDataType(29))), 3);
                vector.setElementAt(new CIMProperty("CECCageNum", new CIMValue(vector7, new CIMDataType(21))), 4);
                vector.setElementAt(new CIMProperty("FSNMtms", new CIMValue(vector8, new CIMDataType(29))), 5);
                vector.setElementAt(new CIMProperty("FSNCageNum", new CIMValue(vector9, new CIMDataType(21))), 6);
            }
            Trace.trace("apihhscT", "<- in FrameUtils.getFrameInfo method");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.getFrameInfo method");
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.getFrameInfo method");
            throw new HSCCIMException("3058");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CIMValue getEnvInfo(CIMObjectPath cIMObjectPath, Vector vector, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("FrameUtils.getEnvInfo....");
        System.out.println("*****The frame name is :" + string);
        System.out.println("*****Obtaining the  frame lock *****");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("getEnvInfo"));
            CIMValue cIMValue = FrameUtils.getEnvInfo0(cIMObjectPath, vector, providerCIMOMHandle);
            Object var8_7 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            throw throwable;
        }
    }

    protected static CIMValue getEnvInfo0(CIMObjectPath cIMObjectPath, Vector vector, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apihhscT", "-> in FrameUtils.getEnvInfo method");
        System.out.println("In getEnvInfo!");
        try {
            int n;
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
            System.out.println("Frame instance: " + cIMInstance);
            System.out.println("getting port numbers!");
            System.out.println("value: " + cIMInstance.getProperty("PortNum").getValue());
            if (cIMInstance.getProperty("PortNum").getValue() == null) {
                throw new HSCCIMException("305F");
            }
            Vector vector2 = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
            UnsignedInt32[] unsignedInt32Array = vector2.toArray(new UnsignedInt32[0]);
            int n2 = unsignedInt32Array.length;
            int n3 = -1;
            int n4 = 0;
            long l = 0L;
            BPAClientExt bPAClientExt = BPAClientExt.getInstance();
            int[] nArray = new int[6];
            int[] nArray2 = new int[17];
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            int n5 = 0;
            while (n5 < n2) {
                n4 = n5;
                l = unsignedInt32Array[n5].longValue();
                n3 = bPAClientExt.getEnvInfo(l, nArray2, nArray);
                System.out.println("getEnvInfo Status: " + n3 + " port: " + l);
                if (n3 == 0) break;
                System.out.println("Return code: " + n3);
                FrameUtils.checkHWServer(n3);
                ++n5;
            }
            System.out.println("status at end: " + n3);
            System.out.println("used port number: " + l);
            System.out.println("bpa index: " + n4);
            if (n3 != 0) {
                System.out.println("getEnvInfo return code: " + n3);
                throw new HSCCIMException("3060");
            }
            Vector<UnsignedInt8> vector5 = new Vector<UnsignedInt8>();
            Vector<UnsignedInt8> vector6 = null;
            Vector[] vectorArray = new Vector[2];
            int n6 = 0;
            int n7 = 0;
            while (n7 < 2) {
                vector6 = new Vector<UnsignedInt8>();
                n = 0;
                while (n < nArray.length) {
                    n6 = nArray[n];
                    vector6.addElement(new UnsignedInt8((short)n6));
                    ++n;
                }
                vectorArray[n7] = vector6;
                ++n7;
            }
            n = 0;
            while (n < nArray2.length) {
                n6 = nArray2[n];
                vector5.addElement(new UnsignedInt8((short)n6));
                ++n;
            }
            vector.setSize(3);
            if (GlobalConfig.callMethodsWithValues) {
                vector.setElementAt(new CIMValue(vector5, new CIMDataType(21)), 0);
                vector.setElementAt(new CIMValue(vectorArray[0], new CIMDataType(21)), 1);
                vector.setElementAt(new CIMValue(vectorArray[1], new CIMDataType(21)), 2);
            } else {
                vector.setElementAt(new CIMProperty("CECTemps", new CIMValue(vector5, new CIMDataType(21))), 0);
                vector.setElementAt(new CIMProperty("Power1", new CIMValue(vectorArray[0], new CIMDataType(21))), 1);
                vector.setElementAt(new CIMProperty("Power2", new CIMValue(vectorArray[1], new CIMDataType(21))), 2);
            }
            Trace.trace("apihhscT", "<- in FrameUtils.getEnvInfo method");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.getEnvInfo method");
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.getEnvInfo method");
            throw new HSCCIMException("3060");
        }
    }

    public static int getFrameNumberFromBPA(CIMInstance cIMInstance) throws CIMException {
        int[] nArray = new int[1];
        Vector vector = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
        int n = -1;
        BPAClientExt bPAClientExt = BPAClientExt.getInstance();
        int n2 = 0;
        while (n2 < vector.size()) {
            UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector.elementAt(n2);
            n = bPAClientExt.getFrameNumber(unsignedInt32.longValue(), nArray);
            System.out.println("getFrameNumber Status: " + n + " port: " + unsignedInt32.longValue());
            if (n == 0) break;
            System.out.println("Return code: " + n);
            FrameUtils.checkHWServer(n);
            ++n2;
        }
        if (n != 0) {
            throw new HSCCIMException("3058");
        }
        return nArray[0];
    }

    public static void updateFrameNumberFromBPA(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        UnsignedInt16 unsignedInt16;
        int n = FrameUtils.getFrameNumberFromBPA(cIMInstance);
        if (n != (unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("FrameNumber").getValue().getValue()).intValue()) {
            CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
            cIMInstance2.setProperty("FrameNumber", new CIMValue((Object)new UnsignedInt16(n)));
            CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath, cIMInstance2);
            System.out.println("@@@@@@@@@@Sending modify frame indication");
            AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFrameNumberFromCec(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, String string, String string2) throws CIMException {
        HscProviderSocket hscProviderSocket = null;
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string);
            System.out.println("got socket lock!");
            int n = FrameUtils.getFrameNumberFromCec(cIMOMHandle, cIMObjectPath, cIMInstance, hscProviderSocket, string2);
            Object var8_7 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
            return n;
        }
        catch (Throwable throwable) {
            block3: {
                Object var8_8 = null;
                if (hscProviderSocket == null) break block3;
                hscProviderSocket.releaseLock();
            }
            throw throwable;
        }
    }

    public static int getFrameNumberFromCec(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, HscProviderSocket hscProviderSocket, String string) throws HSCCIMException {
        int n = VersionComparator.CSPVersionValue(string);
        if ((float)n <= 3000.0f) {
            return 0;
        }
        try {
            Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_FRAME_NUMBER", null, hscProviderSocket, string);
            Integer n2 = (Integer)hashtable.get("FRAME_NUMBER");
            return n2;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            return -1;
        }
    }

    protected static CIMValue refreshFrame(CIMObjectPath cIMObjectPath, Vector vector, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apihhscD", "-> in FrameUtils.refreshFrame method");
        System.out.println("In refreshFrame!");
        short s = 1;
        HscProviderSocket hscProviderSocket = null;
        try {
            Hashtable hashtable;
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
            System.out.println("Frame instance: " + cIMInstance);
            boolean bl = (Boolean)cIMInstance.getProperty("isFrame").getValue().getValue();
            String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            if (bl) {
                hashtable = FrameUtils.getFrameInfo(cIMInstance);
                FrameUtils.updateFrameNumberFromBPA((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, cIMInstance);
                FrameUtils.createCecFromFrameInfo(cIMObjectPath, (CIMOMHandle)providerCIMOMHandle, string, hashtable, true);
                s = 0;
            } else {
                Object object;
                hashtable = new CIMObjectPath("IBMHSC_FrameCompSys", "root/ibmhscV3_2");
                Enumeration enumeration = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)hashtable, cIMObjectPath, "IBMHSC_ComputerSystem", "GroupComponent", "PartComponent").elements();
                boolean bl2 = false;
                while (enumeration.hasMoreElements()) {
                    String string2;
                    String string3;
                    String string4;
                    object = (CIMObjectPath)enumeration.nextElement();
                    CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)object, new CIMClass("IBMHSC_ComputerSystem"), false);
                    System.out.println("Cec instance: " + cIMInstance2);
                    String string5 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
                    String string6 = null;
                    int n = ((UnsignedInt16)cIMInstance2.getProperty("Capability").getValue().getValue()).intValue();
                    System.out.println("cec capability: " + n);
                    String string7 = (String)cIMInstance2.getProperty("CSPVersion").getValue().getValue();
                    if ((n & 0x40) != 64) continue;
                    System.out.println("An IH CEC!");
                    boolean bl3 = true;
                    try {
                        hscProviderSocket = ProviderLceCommunication.obtainSocket(string5);
                        System.out.println("got socket lock!");
                        Hashtable hashtable2 = HscProviderUtils.doCSPCommand("GET_BPA_TYPE_SERIAL_NO", null, hscProviderSocket, string7);
                        if (hscProviderSocket != null) {
                            hscProviderSocket.releaseLock();
                            hscProviderSocket = null;
                            System.out.println("Released socket lock!");
                        }
                        string4 = (String)hashtable2.get("BPA_TYPE");
                        string3 = (String)hashtable2.get("SERIAL_NO");
                        System.out.println("The BPA model type is :" + string4);
                        System.out.println("The BPA serial num is :" + string3);
                        string2 = string4.concat("*");
                        string6 = string2.concat(string3);
                        System.out.println("The BPA MTMS is :" + string6);
                    }
                    catch (Throwable throwable) {
                        System.out.println("Couldn't find a BPA MTMS for cec " + object);
                        throwable.printStackTrace();
                        bl3 = false;
                        if (hscProviderSocket != null) {
                            hscProviderSocket.releaseLock();
                        }
                        hscProviderSocket = null;
                    }
                    if (!bl3) continue;
                    int n2 = FrameUtils.getFrameNumberFromCec((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, cIMInstance, string5, string7);
                    s = 0;
                    string4 = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
                    string4.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
                    string4.addKey("Name", new CIMValue(string6));
                    System.out.println("");
                    string3 = null;
                    try {
                        string3 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)string4, new CIMClass("IBMHSC_Frame"), false);
                        System.out.println("frame instance: " + string3);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    if (string3 == null) {
                        if (n2 == -1) {
                            n2 = 0;
                        }
                        string4 = ComputerSystemProvUtils.buildFrameInstance(string6, (CIMOMHandle)providerCIMOMHandle, false, 5, n2);
                        System.out.println("New frame instance created!  Object path: " + string4);
                        string3 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)string4, new CIMClass("IBMHSC_Frame"), false);
                        System.out.println("@@@@@@@@@@Sending create frame indication");
                        AsynchEventManager.sendIndication(1, (CIMInstance)string3, null);
                    } else if (n2 != -1 && n2 != (string2 = (UnsignedInt16)string3.getProperty("FrameNumber").getValue().getValue()).intValue()) {
                        CIMInstance cIMInstance3 = string3.filterProperties(null, true, true);
                        cIMInstance3.setProperty("FrameNumber", new CIMValue((Object)new UnsignedInt16(n2)));
                        CimomWrapper.setInstance((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)string4, cIMInstance3);
                        System.out.println("@@@@@@@@@@Sending modify frame indication");
                        AsynchEventManager.sendIndication(4, cIMInstance3, (CIMInstance)string3);
                    }
                    HscProviderUtils.deleteReferences((CIMOMHandle)providerCIMOMHandle, "IBMHSC_FrameCompSys", (CIMObjectPath)object);
                    ComputerSystemProvUtils.buildFrameCecAss((CIMObjectPath)string4, (CIMObjectPath)object, (CIMOMHandle)providerCIMOMHandle);
                }
                object = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)hashtable, cIMObjectPath, "IBMHSC_ComputerSystem", "GroupComponent", "PartComponent");
                if (((Vector)object).size() == 0) {
                    CimomWrapper.deleteInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath);
                    System.out.println("@@@@@@@@@@Sending delete frame indication");
                    AsynchEventManager.sendIndication(2, cIMInstance, null);
                }
            }
            hashtable = new UnsignedInt8(s);
            vector.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector.setElementAt(new CIMValue((Object)hashtable), 0);
            } else {
                vector.setElementAt(new CIMProperty("OpValue", new CIMValue((Object)hashtable)), 0);
            }
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscD", "<- in FrameUtils.refreshFrame method");
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscD", "<- in FrameUtils.refreshFrame method");
            throw new HSCCIMException("3059");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CIMValue powerOffCSP(CIMObjectPath cIMObjectPath, Vector vector, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("FrameUtils.powerOffCSP....");
        System.out.println("*****The frame name is : " + string);
        System.out.println("*****Obtaining the  frame lock *****");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("powerOffCSP"));
            CIMValue cIMValue = FrameUtils.powerOffCSP0(cIMObjectPath, vector, providerCIMOMHandle);
            Object var8_7 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            throw throwable;
        }
    }

    protected static CIMValue powerOffCSP0(CIMObjectPath cIMObjectPath, Vector vector, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apihhscT", "-> in FrameUtils.powerOffCSP method");
        System.out.println("In powerOffCSP!");
        Vector vector2 = new Vector();
        try {
            vector2 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            System.out.println("cec cage nums: " + vector2);
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
            System.out.println("Frame instance: " + cIMInstance);
            String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            System.out.println("port nums value: " + cIMInstance.getProperty("PortNum").getValue());
            if (cIMInstance.getProperty("PortNum").getValue() == null) {
                throw new HSCCIMException("305F");
            }
            Vector vector3 = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
            UnsignedInt32[] unsignedInt32Array = vector3.toArray(new UnsignedInt32[0]);
            long l = 0L;
            int n = -1;
            int n2 = unsignedInt32Array.length;
            boolean bl = false;
            BPAClientExt bPAClientExt = BPAClientExt.getInstance();
            int n3 = 0;
            while (n3 < vector2.size()) {
                int n4 = ((UnsignedInt8)vector2.elementAt(n3)).intValue();
                System.out.println("FrameUtils.powerOffCSP0() - deactivating cage number " + n4);
                if (unsignedInt32Array.length == 2) {
                    n = bPAClientExt.deactivateCspWithPorts(unsignedInt32Array[0].longValue(), unsignedInt32Array[1].longValue(), n4);
                } else if (unsignedInt32Array.length == 1) {
                    n = bPAClientExt.deactivateCsp(unsignedInt32Array[0].longValue(), n4);
                }
                System.out.println("FrameUtils.powerOffCSP0() - deactivateCsp() return code = " + n);
                if (n != 0) {
                    FrameUtils.checkHWServer(n);
                    if (n != 0 && n == 2552) {
                        throw new HSCCIMException("3064");
                    }
                    if (n != 0) {
                        throw new HSCCIMException("3055");
                    }
                }
                ++n3;
            }
            System.out.println("Successfully deactivated CSPs!");
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.powerOffCSP method");
            throw new HSCCIMException("3055");
        }
        Trace.trace("apihhscT", "<- in FrameUtils.powerOffCSP method");
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CIMValue powerOffFSN(CIMObjectPath cIMObjectPath, Vector vector, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("FrameUtils.powerOffFSN....");
        System.out.println("*****The frame name is : " + string);
        System.out.println("*****Obtaining the  frame lock *****");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("powerOffFSN"));
            CIMValue cIMValue = FrameUtils.powerOffFSN0(cIMObjectPath, vector, providerCIMOMHandle);
            Object var8_7 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            throw throwable;
        }
    }

    protected static CIMValue powerOffFSN0(CIMObjectPath cIMObjectPath, Vector vector, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apihhscT", "-> in FrameUtils.powerOffFSN method");
        System.out.println("In powerOffFSN!");
        Vector vector2 = new Vector();
        try {
            vector2 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            System.out.println("cec cage nums: " + vector2);
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
            System.out.println("Frame instance: " + cIMInstance);
            String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            System.out.println("port nums value: " + cIMInstance.getProperty("PortNum").getValue());
            if (cIMInstance.getProperty("PortNum").getValue() == null) {
                throw new HSCCIMException("305F");
            }
            Vector vector3 = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
            UnsignedInt32[] unsignedInt32Array = vector3.toArray(new UnsignedInt32[0]);
            long l = 0L;
            int n = -1;
            int n2 = unsignedInt32Array.length;
            boolean bl = false;
            BPAClientExt bPAClientExt = BPAClientExt.getInstance();
            int n3 = 0;
            while (n3 < vector2.size()) {
                int n4 = ((UnsignedInt8)vector2.elementAt(n3)).intValue();
                if (unsignedInt32Array.length == 2) {
                    n = bPAClientExt.deactivateCspWithPorts(unsignedInt32Array[0].longValue(), unsignedInt32Array[1].longValue(), n4);
                } else if (unsignedInt32Array.length == 1) {
                    n = bPAClientExt.deactivateCsp(unsignedInt32Array[0].longValue(), n4);
                }
                System.out.println("FrameUtils.powerOffFSN0 - deactivateCsp() return code = " + n);
                if (n != 0) {
                    FrameUtils.checkHWServer(n);
                    System.out.println("Error during deactivateFSN.  Return code: " + n);
                    throw new HSCCIMException("3061");
                }
                System.out.println("Successfully deactivated FSNs!");
                ++n3;
            }
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.powerOffFSN method");
            throw new HSCCIMException("3061");
        }
        Trace.trace("apihhscT", "<- in FrameUtils.powerOffFSN method");
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CIMValue resetCSP(CIMObjectPath cIMObjectPath, Vector vector, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("FrameUtils.resetCSP....");
        System.out.println("*****The frame name is : " + string);
        System.out.println("*****Obtaining the  frame lock *****");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("resetCSP"));
            CIMValue cIMValue = FrameUtils.resetCSP0(cIMObjectPath, vector, providerCIMOMHandle);
            Object var8_7 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            throw throwable;
        }
    }

    protected static CIMValue resetCSP0(CIMObjectPath cIMObjectPath, Vector vector, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apihhscT", "-> in FrameUtils.resetCSP method");
        System.out.println("In resetCSP!");
        Vector vector2 = new Vector();
        try {
            vector2 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            System.out.println("cec cage numbers: " + vector2);
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
            System.out.println("Frame instance: " + cIMInstance);
            String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            System.out.println("port nums value: " + cIMInstance.getProperty("PortNum").getValue());
            if (cIMInstance.getProperty("PortNum").getValue() == null) {
                throw new HSCCIMException("305F");
            }
            Vector vector3 = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
            UnsignedInt32[] unsignedInt32Array = vector3.toArray(new UnsignedInt32[0]);
            long l = 0L;
            int n = -1;
            int n2 = unsignedInt32Array.length;
            int n3 = 0;
            BPAClientExt bPAClientExt = BPAClientExt.getInstance();
            int n4 = 0;
            while (n4 < vector2.size()) {
                int n5 = ((UnsignedInt8)vector2.elementAt(n4)).intValue();
                int n6 = 0;
                while (n6 < n2) {
                    n3 = n6;
                    l = unsignedInt32Array[n6].longValue();
                    n = bPAClientExt.pinholeReset(l, n5);
                    System.out.println("pinholeReset return code: " + n + " port: " + l);
                    if (n == 0) break;
                    System.out.println("Return code: " + n);
                    FrameUtils.checkHWServer(n);
                    ++n6;
                }
                System.out.println("status at end: " + n);
                System.out.println("used port number: " + l);
                System.out.println("bpa index: " + n3);
                if (n != 0) {
                    System.out.println("Error during pinhole reset - return code " + n);
                    throw new HSCCIMException("3056");
                }
                ++n4;
            }
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.resetCSP method");
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.resetCSP method");
            throw new HSCCIMException("3056");
        }
        Trace.trace("apihhscT", "<- in FrameUtils.resetCSP method");
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CIMValue powerOffIO(CIMObjectPath cIMObjectPath, Vector vector, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        System.out.println("FrameUtils.powerOffIO....");
        System.out.println("*****The frame name is : " + string);
        System.out.println("*****Obtaining the  frame lock *****");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("powerOffIO"));
            CIMValue cIMValue = FrameUtils.powerOffIO0(cIMObjectPath, vector, string, providerCIMOMHandle);
            Object var8_7 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            hscCecLock.Unlock();
            System.out.println("Released Frame lock!");
            throw throwable;
        }
    }

    protected static CIMValue powerOffIO0(CIMObjectPath cIMObjectPath, Vector vector, String string, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apihhscT", "-> in FrameUtils.powerOffIO method");
        System.out.println("In powerOffIO!");
        Vector vector2 = new Vector();
        try {
            vector2 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            System.out.println("IO cage numbers: " + vector2);
            System.out.println("number of cage numbers sent down: " + vector2.size());
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
            System.out.println("Frame instance: " + cIMInstance);
            String string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
            System.out.println("port nums value: " + cIMInstance.getProperty("PortNum").getValue());
            if (cIMInstance.getProperty("PortNum").getValue() == null) {
                throw new HSCCIMException("305F");
            }
            Vector vector3 = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
            UnsignedInt32[] unsignedInt32Array = vector3.toArray(new UnsignedInt32[0]);
            long l = 0L;
            int n = unsignedInt32Array.length;
            int n2 = -1;
            boolean bl = false;
            short s = ((UnsignedInt16)cIMInstance.getProperty("frameType").getValue().getValue()).shortValue();
            System.out.println("FrameUtils.powerOffIO0 - frameType = " + Integer.toHexString(s));
            BPAClientExt bPAClientExt = BPAClientExt.getInstance();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            System.out.println("remainder: " + vector2.size() % 2);
            if (vector2.size() % 2 != 0) {
                System.out.println("Odd number of cages sent down!");
                throw new HSCCIMException("305A");
            }
            System.out.println("number of times in loop: " + vector2.size() / 2);
            int n6 = 0;
            while (n6 < vector2.size() / 2) {
                int n7;
                System.out.println("i= " + n5);
                n3 = ((UnsignedInt8)vector2.elementAt(n5)).intValue();
                System.out.println("cage num. 1: " + n3);
                System.out.println("i = " + ++n5);
                n4 = ((UnsignedInt8)vector2.elementAt(n5)).intValue();
                System.out.println("cage num. 2: " + n4);
                ++n5;
                if (n3 % 2 == 0) {
                    n7 = n3 - 1;
                    System.out.println("cage number should be: " + n7);
                    if (n4 != n7 && (s == 0 || s == 2)) {
                        System.out.println("In params not sent in Bonnie/Clyde pairs!!");
                        throw new HSCCIMException("305B");
                    }
                } else {
                    n7 = n3 + 1;
                    System.out.println("cage number should be: " + n7);
                    if (n4 != n7 && (s == 0 || s == 2)) {
                        System.out.println("In params not sent in Bonnie/Clyde pairs!!");
                        throw new HSCCIMException("305B");
                    }
                }
                if (unsignedInt32Array.length == 2) {
                    n2 = bPAClientExt.deactivateCspWithPorts(unsignedInt32Array[0].longValue(), unsignedInt32Array[1].longValue(), n3);
                } else if (unsignedInt32Array.length == 1) {
                    n2 = bPAClientExt.deactivateCsp(unsignedInt32Array[0].longValue(), n3);
                }
                System.out.println("FrameUtils.powerOffIO0 - deactivateCsp() return code = " + n2);
                if (n2 != 0) {
                    FrameUtils.checkHWServer(n2);
                }
                System.out.println("status at end: " + n2);
                if (n2 != 0) {
                    throw new HSCCIMException("3057");
                }
                ++n6;
            }
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.powerOffIO method");
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.powerOffIO method");
            throw new HSCCIMException("3057");
        }
        Trace.trace("apihhscT", "<- in FrameUtils.powerOffIO method");
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    protected static void tmpGetFrameInfo(int[] nArray, String[] stringArray, int[] nArray2, int[] nArray3) {
        nArray[0] = 0;
        nArray[1] = 255;
        nArray[2] = 16;
        nArray[3] = 255;
        nArray[4] = 16;
        nArray[5] = 32;
        nArray[6] = 32;
        nArray[7] = 32;
        nArray[8] = 32;
        nArray[9] = 255;
        nArray[10] = 255;
        nArray[11] = 32;
        nArray[12] = 32;
        nArray[13] = 255;
        nArray[14] = 255;
        nArray[15] = 255;
        nArray[16] = 255;
        stringArray[0] = "7040-293*2109358";
        stringArray[1] = "tmp1";
        stringArray[2] = "7040-600*1234567";
        stringArray[3] = "tmp2";
        stringArray[4] = "7020-111*10958191";
        stringArray[5] = "7040-600*U2Drawer00001";
        stringArray[6] = "7040-600*U1Drawer00003";
        stringArray[7] = "7040-600*U1Drawer00002";
        stringArray[8] = "7040-600*U2Drawer0000d";
        stringArray[9] = "tmp4";
        stringArray[10] = "tmp5";
        stringArray[11] = "7040-600*U2Drawer00005";
        stringArray[12] = "7040-600*U1Drawer00001";
        stringArray[13] = "tmp6";
        stringArray[14] = "tmp7";
        stringArray[15] = "tmp8";
        stringArray[16] = "tmp9";
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 1;
        nArray2[3] = 0;
        nArray2[4] = 0;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 0;
        nArray2[10] = 0;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 0;
        nArray2[14] = 0;
        nArray2[15] = 0;
        nArray2[16] = 0;
        nArray3[0] = 0;
        nArray3[1] = 0;
        nArray3[2] = 1;
        nArray3[3] = 0;
        nArray3[4] = 0;
        nArray3[5] = -1;
        nArray3[6] = 2;
        nArray3[7] = 2;
        nArray3[8] = -1;
        nArray3[9] = 0;
        nArray3[10] = 0;
        nArray3[11] = -1;
        nArray3[12] = 2;
        nArray3[13] = 0;
        nArray3[14] = 0;
        nArray3[15] = 0;
        nArray3[16] = 0;
    }

    protected static boolean notPoweredOn(CIMObjectPath[] cIMObjectPathArray, ProviderCIMOMHandle providerCIMOMHandle) {
        boolean bl = false;
        CIMInstance cIMInstance = null;
        int n = 0;
        while (n < cIMObjectPathArray.length) {
            boolean bl2 = true;
            int n2 = 0;
            CIMObjectPath cIMObjectPath = cIMObjectPathArray[n];
            try {
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
                System.out.println("cecInstance: " + cIMInstance);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                bl2 = false;
            }
            if (bl2 && cIMInstance != null) {
                n2 = ((UnsignedInt8)cIMInstance.getProperty("State").getValue().getValue()).intValue();
                System.out.println("The CEC's state is: " + n2);
                if (n2 != 1) {
                    System.out.println("not finished!");
                    bl = true;
                }
            }
            ++n;
        }
        return bl;
    }

    public static CIMObjectPath createDrawer(CIMOMHandle cIMOMHandle, String string, String string2, int n) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        Trace.trace("apihhscT", "the frame name in createDrawer is " + string2);
        try {
            cIMObjectPath = new CIMObjectPath("IBMHSC_IODrawer", "root/ibmhscV3_2");
            cIMObjectPath.addKey("DeviceID", new CIMValue((Object)string));
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)string2));
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
            cIMObjectPath3 = cIMObjectPath;
            try {
                cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, cIMOMHandle.getClass(cIMObjectPath, false), false);
                System.out.println("ioInst: " + cIMInstance2);
            }
            catch (Throwable throwable) {
                System.out.println("IO instance does not exist.");
                cIMInstance2 = null;
            }
            if (cIMInstance2 == null) {
                System.out.println("Creating new IO instance!");
                cIMClass = cIMOMHandle.getClass(cIMObjectPath, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("DeviceID", new CIMValue((Object)string));
                cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMInstance.setProperty("SystemName", new CIMValue((Object)string2));
                cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                cIMInstance.setProperty("CageNumber", new CIMValue((Object)new UnsignedInt8((short)n)));
                cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                cIMObjectPath3 = CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath2, cIMInstance);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in drawer creation...");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        return cIMObjectPath3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCecFromFrameInfo(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle, String string, Hashtable hashtable, boolean bl) throws CIMException {
        HscLockManager hscLockManager = null;
        System.out.println("In createCecFromFrameInfo");
        System.out.println("***********************************************");
        try {
            try {
                Trace.trace("apihhscT", "-> createCecFromFrameInfo");
                System.out.println("Get the frame instance to get the port numbers");
                System.out.println("frameName: " + string);
                String[] stringArray = (String[])hashtable.get("mtms");
                int[] nArray = (int[])hashtable.get("type");
                Vector<String> vector = new Vector<String>();
                vector.add(string);
                int n = 1;
                while (n < 17) {
                    if (nArray[n] == 16 && stringArray[n] != null) {
                        vector.add(stringArray[n]);
                    }
                    ++n;
                }
                System.out.println("the lock vector is :" + vector);
                hscLockManager = HscLockManager.GetHscProviderLockManager();
                System.out.println("lockVec.size=" + vector.size());
                if (vector.size() > 1) {
                    hscLockManager.setGroupLock(4, vector, 0);
                    if (hscLockManager == null) {
                        System.out.print("######fail to get the group lock\n");
                    }
                    try {
                        System.out.println("The Vector size is ######" + vector.size());
                        int n2 = 1;
                        while (n2 < vector.size()) {
                            String string2 = (String)vector.elementAt(n2);
                            System.out.println("The Cec name in building CEC's is :" + string2);
                            FrameUtils.createCecBelongToFrame(string2, string, cIMObjectPath, cIMOMHandle, bl);
                            ++n2;
                        }
                        Object var13_13 = null;
                        System.out.println("##### Releasing the group lock #####");
                        if (hscLockManager != null) {
                            hscLockManager.releaseGroupLock();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        System.out.println("##### Releasing the group lock #####");
                        if (hscLockManager != null) {
                            hscLockManager.releaseGroupLock();
                        }
                        throw throwable;
                    }
                }
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                throw new HSCCIMException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            Trace.trace("apihhscT", "<- createCecFromFrameInfo");
            throw throwable;
        }
        Trace.trace("apihhscT", "<- createCecFromFrameInfo");
    }

    public static void createCecFromFrameInfoNoLock(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle, String string, Hashtable hashtable, boolean bl) throws CIMException {
        Object var5_5 = null;
        System.out.println("In createCecFromFrameInfo");
        System.out.println("***********************************************");
        try {
            try {
                Trace.trace("apihhscT", "-> createCecFromFrameInfo");
                System.out.println("Get the frame instance to get the port numbers");
                System.out.println("frame name: " + string);
                String[] stringArray = (String[])hashtable.get("mtms");
                int[] nArray = (int[])hashtable.get("type");
                int n = 1;
                while (n < 17) {
                    if (nArray[n] == 16 && stringArray[n] != null) {
                        System.out.println("The Cec name in building CEC's is :" + stringArray[n]);
                        FrameUtils.createCecBelongToFrame(stringArray[n], string, cIMObjectPath, cIMOMHandle, bl);
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Trace.trace("apihhscT", "<- createCecFromFrameInfo");
            throw throwable;
        }
        Trace.trace("apihhscT", "<- createCecFromFrameInfo");
    }

    public static void setFrameNumToCec(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, HscProviderSocket hscProviderSocket, String string, boolean bl) {
        block4: {
            System.out.println("In setFrameNumToCec");
            if (cIMObjectPath == null) {
                return;
            }
            try {
                int n;
                CIMInstance cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, cIMOMHandle.getClass(cIMObjectPath, false), false);
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("frameType").getValue().getValue();
                int n2 = unsignedInt16.intValue();
                System.out.println("frameType=" + n2);
                if (n2 != 0 && n2 != 1 && n2 != 2 || !((float)(n = VersionComparator.CSPVersionValue(string)) > 3000.0f)) break block4;
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)cIMInstance.getProperty("frameNumber").getValue().getValue();
                HscProviderUtils.doCSPCommand("SET_FRAME_NUMBER", new String[]{unsignedInt162.toString()}, hscProviderSocket, string);
                if (n2 == 0 || n2 == 2) break block4;
                Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_HMC_MANAGED_UCODE", null, hscProviderSocket, string);
                Integer n3 = (Integer)hashtable.get("HMC_MANAGED_UCODE");
                short s = n3.shortValue();
                System.out.println("HMC_MANAGED_UCODE=" + s);
                if (s == 0) {
                    HscProviderUtils.doCSPCommand("SET_HMC_MANAGED_UCODE", new String[]{"1"}, hscProviderSocket, string);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
        }
    }

    public static void createCecBelongToFrame(String string, String string2, CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle, boolean bl) throws CIMException {
        System.out.println("In createCecBelongToFrame");
        Trace.trace("apihhscT", "-> createCecBelongToFrame");
        HscProviderSocket hscProviderSocket = null;
        try {
            try {
                block10: {
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                    cIMObjectPath2.addKey("Name", new CIMValue((Object)string));
                    try {
                        System.out.println("Checking if the cec exists");
                        CIMInstance cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath2, cIMOMHandle.getClass(cIMObjectPath2, false), false);
                        if (cIMInstance == null) {
                            System.out.println("Frame does not exists in null block");
                            FrameUtils.createCecAndAssoc(string, cIMObjectPath, cIMOMHandle);
                        } else {
                            FrameUtils.checkCecFrameAss(cIMObjectPath2, cIMObjectPath, string2, cIMOMHandle);
                            String string3 = (String)cIMInstance.getProperty("CSPVersion").getValue().getValue();
                            hscProviderSocket = ProviderLceCommunication.obtainSocket(string);
                            FrameUtils.setFrameNumToCec(cIMOMHandle, cIMObjectPath, hscProviderSocket, string3, bl);
                        }
                    }
                    catch (CIMException cIMException) {
                        if (!cIMException.getID().equals("CIM_ERR_NOT_FOUND")) break block10;
                        System.out.println("Cec does not exists in catch block");
                        FrameUtils.createCecAndAssoc(string, cIMObjectPath, cIMOMHandle);
                    }
                }
                Object var10_11 = null;
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                throw new HSCCIMException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
            Trace.trace("apihhscT", "<- createCecBelongToFrame");
            throw throwable;
        }
        Trace.trace("apihhscT", "<- createCecBelongToFrame");
    }

    public static void createCecAndAssoc(String string, CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        System.out.println("In createCecAndAssoc");
        Trace.trace("apihhscT", "-> createCecAndAssoc");
        try {
            try {
                int n = string.indexOf(42);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
                CIMClass cIMClass = cIMOMHandle.getClass(cIMObjectPath2, false);
                CIMInstance cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMInstance.setProperty("Name", new CIMValue((Object)string));
                cIMInstance.setProperty("state", new CIMValue((Object)new UnsignedInt8(254)));
                cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string));
                cIMInstance.setProperty("SerialNumber", new CIMValue((Object)string3));
                cIMInstance.setProperty("Model", new CIMValue((Object)string2));
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                System.out.println("Creating the CEC in no connection since part of a frame");
                CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance);
                System.out.println("Creating the Ass between frame and no-connection cec");
                ComputerSystemProvUtils.buildFrameCecAss(cIMObjectPath, cIMObjectPath3, cIMOMHandle);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Trace.trace("apihhscT", "<- createCecAndAssoc");
            throw throwable;
        }
        Trace.trace("apihhscT", "<- createCecAndAssoc");
    }

    public static void deleteCecFrameAsso(CIMOMHandle cIMOMHandle, CIMInstance cIMInstance, HSCEventQueue hSCEventQueue) throws CIMException {
        System.out.println("------deleteFrameCecAsso------");
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_FrameCompSys", "root/ibmhscV3_2");
        cIMObjectPath.addKey("GroupComponent", cIMInstance.getProperty("GroupComponent").getValue());
        cIMObjectPath.addKey("PartComponent", cIMInstance.getProperty("PartComponent").getValue());
        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty("GroupComponent").getValue().getValue();
        CIMInstance cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Frame"), false);
        Vector vector = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath, cIMObjectPath2, "IBMHSC_ComputerSystem", "GroupComponent", "PartComponent");
        if (vector.size() == 0) {
            Boolean bl = (Boolean)cIMInstance2.getProperty("isFrame").getValue().getValue();
            if (!bl.booleanValue()) {
                System.out.println("This dummy frame no longer has any CECs attached to it, so delete the frame...");
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
                if (hSCEventQueue != null) {
                    hSCEventQueue.add(2, cIMInstance2, null);
                } else {
                    AsynchEventManager.sendIndication(2, cIMInstance2, null);
                }
            }
        } else if (hSCEventQueue != null) {
            hSCEventQueue.add(2, cIMInstance, null);
        } else {
            AsynchEventManager.sendIndication(2, cIMInstance, null);
        }
    }

    public static void checkCecFrameAss(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, CIMOMHandle cIMOMHandle) throws CIMException {
        System.out.println("In checkCecFrameAss");
        System.out.println("The cec object path is :" + cIMObjectPath);
        System.out.println("The frame object path is :" + cIMObjectPath2);
        Trace.trace("apihhscT", "<- checkCecFrameAssoc");
        try {
            block6: {
                try {
                    CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_FrameCompSys", "root/ibmhscV3_2");
                    Enumeration enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null).elements();
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration.nextElement();
                        CIMInstance cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath4, new CIMClass("IBMHSC_FrameCompSys"), false);
                        CIMObjectPath cIMObjectPath5 = (CIMObjectPath)cIMInstance.getProperty("GroupComponent").getValue().getValue();
                        if (!cIMObjectPath5.equals((Object)cIMObjectPath2) && n < 1) {
                            FrameUtils.deleteCecFrameAsso(cIMOMHandle, cIMInstance, null);
                            continue;
                        }
                        ++n;
                    }
                    if (n != 0) break block6;
                    System.out.println("old association not exist, create a new one");
                    ComputerSystemProvUtils.buildFrameCecAss(cIMObjectPath2, cIMObjectPath, cIMOMHandle);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                    throw new HSCCIMException(throwable);
                }
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Trace.trace("apihhscT", "<- checkCecFrameAssoc");
            throw throwable;
        }
        Trace.trace("apihhscT", "<- checkCecFrameAssoc");
    }

    protected static void checkHWServer(int n) throws CIMException {
        if (n == 2548) {
            throw new HSCCIMException("305C");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CIMValue setFrameNumber(Vector vector, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        int n = 0;
        Trace.trace("apihhscT", "-> in setFrameNumber method");
        System.out.println("In setFrameNumber");
        try {
            if (GlobalConfig.callMethodsWithValues) {
                vector2 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
            } else {
                vector2 = (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            }
            Trace.trace("apihhscD", "Frame MTMS's :" + vector2);
            Trace.trace("apihhscD", "Frame Numbers :" + vector3);
            System.out.println("The Frame MTMS's :" + vector2);
            System.out.println("The Frame numbers :" + vector3);
            HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
            String string = "";
            boolean bl = false;
            int n2 = 0;
            while (n2 < vector2.size()) {
                String string2 = (String)vector2.elementAt(n2);
                if (!string2.equals("UNKNOWN*FRAME")) {
                    Object var17_18;
                    n = ((UnsignedInt16)vector3.elementAt(n2)).intValue();
                    System.out.println("Setting the frame lock");
                    HscCecLock hscCecLock = hscLockManager.getHscCecLock(string2);
                    hscCecLock.Lock(hscLockManager.getLockType("setFrameNumber"));
                    try {
                        block16: {
                            try {
                                UnsignedInt16 unsignedInt16;
                                Object object;
                                CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
                                cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
                                cIMObjectPath.addKey("Name", new CIMValue((Object)string2));
                                CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
                                System.out.println("Frame instance: " + cIMInstance);
                                if (cIMInstance != null) {
                                    boolean bl2 = (Boolean)cIMInstance.getProperty("isFrame").getValue().getValue();
                                    System.out.println("The Frame flag is :" + bl2);
                                    if (bl2) {
                                        System.out.println("port num value: " + cIMInstance.getProperty("PortNum").getValue());
                                        if (cIMInstance.getProperty("PortNum").getValue() == null) {
                                            throw new HSCCIMException("305F");
                                        }
                                        object = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
                                        FrameUtils.setFrameIdViaBPA((Vector)object, n);
                                    }
                                }
                                if (n == (unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("FrameNumber").getValue().getValue()).intValue()) break block16;
                                object = cIMInstance.filterProperties(null, true, true);
                                object.setProperty("FrameNumber", new CIMValue((Object)new UnsignedInt16(n)));
                                CimomWrapper.setInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, object);
                                AsynchEventManager.sendIndication(4, object, cIMInstance);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                System.out.println("Problem setting the frame number for :" + string2);
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                                string = string.concat(" ");
                                string = string.concat(string2);
                                if (throwable instanceof HSCCIMException) {
                                    string = string.concat(" (" + throwable.getMessage() + ")");
                                }
                                if (!bl) {
                                    bl = true;
                                }
                                var17_18 = null;
                                hscCecLock.Unlock();
                                System.out.println("Released Frame lock!" + string2);
                            }
                        }
                        var17_18 = null;
                        hscCecLock.Unlock();
                        System.out.println("Released Frame lock!" + string2);
                    }
                    catch (Throwable throwable) {
                        var17_18 = null;
                        hscCecLock.Unlock();
                        System.out.println("Released Frame lock!" + string2);
                        throw throwable;
                    }
                }
                ++n2;
            }
            if (bl) {
                throw new HSCCIMException("305E", new String[]{string});
            }
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.powerOffIO method");
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
    }

    public static void setFrameIdViaBPA(Vector vector, int n) throws CIMException {
        int n2 = 0;
        int n3 = 0;
        BPAClientExt bPAClientExt = BPAClientExt.getInstance();
        try {
            UnsignedInt32[] unsignedInt32Array = vector.toArray(new UnsignedInt32[0]);
            n3 = bPAClientExt.setFrameNumber(unsignedInt32Array[n2].longValue(), n);
            if (n3 != 0) {
                if (unsignedInt32Array.length > 1) {
                    n3 = bPAClientExt.setFrameNumber(unsignedInt32Array[++n2].longValue(), n);
                }
                System.out.println("bpaClient.setFrameNumber() returned with status " + Integer.toHexString(n3) + " port: " + unsignedInt32Array[n2].longValue());
                if (((short)n3 & 0xFF00) == 19200) {
                    switch ((short)n3 & 0xFF) {
                        case 4: {
                            throw new HSCCIMException("3062");
                        }
                    }
                    throw new HSCCIMException("3063");
                }
                if (n3 != 0) {
                    throw new HSCCIMException("305D");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in setFrameIdViaBPA method");
            if (throwable instanceof HSCCIMException) {
                throw (HSCCIMException)((Object)throwable);
            }
            throw new HSCCIMException("305D");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void setFrameIdViaCSP(CIMObjectPath cIMObjectPath, int n, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        HscProviderSocket hscProviderSocket = null;
        Hashtable hashtable = null;
        String[] stringArray = new String[2];
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_FrameCompSys", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, cIMObjectPath, "IBMHSC_ComputerSystem", "GroupComponent", "PartComponent").elements();
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, new CIMClass("IBMHSC_ComputerSystem"), false);
                String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
                String string2 = (String)cIMInstance.getProperty("CSPVersion").getValue().getValue();
                try {
                    hscProviderSocket = ProviderLceCommunication.obtainSocket(string);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                    throw new HSCCIMException("138A");
                }
                try {
                    stringArray[0] = Integer.toHexString(1);
                    stringArray[1] = HscProviderUtils.getHscID((CIMOMHandle)providerCIMOMHandle);
                    hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", stringArray, hscProviderSocket);
                    if (hashtable == null) {
                        throw new HSCCIMException("01F5");
                    }
                    String[] stringArray2 = new String[1];
                    System.out.println("The frame number is %%%%%%%%%%%:" + n);
                    stringArray2[0] = Integer.toString(n);
                    System.out.println("The frame number as string %%%%%%%%%%%:" + stringArray2[0]);
                    hashtable = HscProviderUtils.doCSPCommand("SET_FRAME_NUMBER", stringArray2, hscProviderSocket, string2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new HSCCIMException("01F5");
                }
                finally {
                    try {
                        if (hscProviderSocket != null) {
                            hscProviderSocket.releaseLock();
                        }
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                    }
                }
            }
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
            HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._FrameClassLogInfo);
            Trace.trace("apihhscT", "<- in FrameUtils.resetCSP method");
            throw new HSCCIMException((Throwable)((Object)hSCCIMException));
        }
        finally {
            block36: {
                System.out.println("Releasing the CSP lock %%%%%%%%%%");
                stringArray[0] = Integer.toHexString(2);
                stringArray[1] = HscProviderUtils.getHscID((CIMOMHandle)providerCIMOMHandle);
                HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", stringArray, hscProviderSocket);
                Object var21_28 = null;
                try {
                    System.out.println("Releasing the socket lock %%%%%%%%%%");
                    hscProviderSocket.releaseLock();
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                }
                break block36;
                {
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
                        Object var21_29 = null;
                        try {
                            System.out.println("Releasing the socket lock %%%%%%%%%%");
                            hscProviderSocket.releaseLock();
                        }
                        catch (Throwable throwable2) {
                            HSCLogUtils.serverLog(throwable2, HSCLogUtils._FrameClassLogInfo);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var21_30 = null;
                    try {
                        System.out.println("Releasing the socket lock %%%%%%%%%%");
                        hscProviderSocket.releaseLock();
                    }
                    catch (Throwable throwable3) {
                        HSCLogUtils.serverLog(throwable3, HSCLogUtils._FrameClassLogInfo);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static Hashtable getFrameInfo(CIMInstance cIMInstance) throws CIMException {
        Vector vector = (Vector)cIMInstance.getProperty("PortNum").getValue().getValue();
        return FrameUtils.getFrameInfo(vector);
    }

    public static Hashtable getFrameInfo(Vector vector) throws CIMException {
        Object object;
        int[] nArray = new int[17];
        String[] stringArray = new String[17];
        int[] nArray2 = new int[17];
        int[] nArray3 = new int[17];
        int n = -1;
        BPAClientExt bPAClientExt = BPAClientExt.getInstance();
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (UnsignedInt32)vector.elementAt(n2);
            n = bPAClientExt.getFrameInfo(object.longValue(), nArray, stringArray, nArray2, nArray3);
            System.out.println("getFrameInfo Status: " + n + " port: " + object.longValue());
            if (n == 0) break;
            System.out.println("Return code: " + n);
            FrameUtils.checkHWServer(n);
            ++n2;
        }
        if (n != 0) {
            throw new HSCCIMException("3058");
        }
        object = new Hashtable();
        ((Hashtable)object).put("type", nArray);
        ((Hashtable)object).put("mtms", stringArray);
        ((Hashtable)object).put("powerOn", nArray2);
        ((Hashtable)object).put("frameOwner", nArray3);
        return object;
    }

    public static int getFrameType(Hashtable hashtable) {
        int[] nArray = (int[])hashtable.get("type");
        return nArray[0];
    }

    public static void updatePortNumbers(CIMOMHandle cIMOMHandle, String string, long[] lArray, CIMInstance cIMInstance, CIMObjectPath cIMObjectPath) {
        try {
            int n = FrameUtils.getPortChangeStatus(cIMInstance, lArray);
            System.out.println("portChangeStatus: " + n);
            if (n == 0) {
                return;
            }
            CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
            if ((n & 1) != 0) {
                System.out.println("set the port number:" + lArray);
                cIMInstance2.setProperty("PortNum", FrameUtils.getCIMValueForPorts(lArray));
                CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath, cIMInstance2);
            }
            boolean bl = false;
            if ((n & 8) != 0) {
                System.out.println("set off the bpa frame type");
                cIMInstance2.setProperty("isFrame", CIMValue.FALSE);
                cIMInstance2.setProperty("frameType", new CIMValue((Object)new UnsignedInt16(5)));
                bl = true;
            }
            if ((n & 4) != 0) {
                cIMInstance2.setProperty("isFrame", CIMValue.TRUE);
                Hashtable hashtable = FrameUtils.getFrameInfo(cIMInstance2);
                cIMInstance2.setProperty("frameType", new CIMValue((Object)new UnsignedInt16(FrameUtils.getFrameType(hashtable))));
                int n2 = 0;
                try {
                    n2 = FrameUtils.getFrameNumberFromBPA(cIMInstance2);
                }
                catch (CIMException cIMException) {
                    System.out.println("FrameUtils.updatePortNumbers() - getFrameNumberFromBPA() failed, clearing frame number");
                    n2 = 0;
                }
                cIMInstance2.setProperty("FrameNumber", new CIMValue((Object)new UnsignedInt16(n2)));
                CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath, cIMInstance2);
                FrameUtils.createCecFromFrameInfoNoLock(cIMObjectPath, cIMOMHandle, string, hashtable, true);
                System.out.println("set on the bpa frame type");
                bl = true;
            }
            if ((n & 2) != 0) {
                int n3 = FrameUtils.getFrameNumberFromBPA(cIMInstance2);
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMInstance.getProperty("FrameNumber").getValue().getValue();
                if (unsignedInt16.intValue() != n3) {
                    cIMInstance2.setProperty("FrameNumber", new CIMValue((Object)new UnsignedInt16(FrameUtils.getFrameNumberFromBPA(cIMInstance2))));
                    bl = true;
                }
            }
            CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath, cIMInstance2);
            if (bl) {
                System.out.println("@@@@@@@@@@Sending modify frame indication");
                AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
        }
    }

    private static int getPortChangeStatus(CIMInstance cIMInstance, long[] lArray) {
        Vector vector = FrameUtils.getExistingPortNums(cIMInstance);
        if (vector == null) {
            if (lArray[0] != -1L || lArray[1] != -1L) {
                return 7;
            }
            return 0;
        }
        if (lArray[0] == -1L && lArray[1] == -1L) {
            return 9;
        }
        return 3;
    }

    private static Vector getExistingPortNums(CIMInstance cIMInstance) {
        CIMProperty cIMProperty = cIMInstance.getProperty("PortNum");
        if (cIMProperty == null) {
            return null;
        }
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue == null) {
            return null;
        }
        Vector vector = (Vector)cIMValue.getValue();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public static CIMValue getCIMValueForPorts(long[] lArray) {
        Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
        if (lArray[0] == -1L && lArray[1] == -1L) {
            return new CIMValue(vector, new CIMDataType(25));
        }
        int n = 0;
        while (n < lArray.length) {
            if (lArray[n] != -1L) {
                vector.add(new UnsignedInt32(lArray[n]));
            }
            ++n;
        }
        return new CIMValue(vector, new CIMDataType(25));
    }
}

